<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('job_questions');

        Schema::create('job_questions', function (Blueprint $table) {
            $table->id('Question_id');
            $table->unsignedBigInteger('Job_id');
            $table->text('Question_text');
            $table->enum('Question_type', ['text', 'multiple_choice', 'single_choice', 'rating_scale', 'boolean'])->default('text');
            $table->json('Options')->nullable()->comment('JSON array for multiple choice options');
            $table->integer('Order')->default(0)->comment('Display order');
            $table->boolean('Is_required')->default(true);
            $table->integer('Max_length')->nullable()->comment('For text questions');
            $table->integer('Min_value')->nullable()->comment('For rating scale');
            $table->integer('Max_value')->nullable()->comment('For rating scale');
            $table->json('Validation_rules')->nullable()->comment('JSON validation rules');
            $table->decimal('Weight', 5, 2)->default(1.00)->comment('Scoring weight');
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('Job_id', 'job_questions_job_id_foreign')->references('Job_id')->on('jobs')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('job_questions');

        Schema::create('job_questions', function (Blueprint $table) {
            $table->id('Question_id');
            $table->unsignedBigInteger('Job_id');
            $table->text('Question_text');
            $table->timestamps();
            $table->foreign('Job_id')->references('Job_id')->on('jobs')->onDelete('cascade');
        });
    }
};
